#!/usr/bin/perl
#
###############################################################################
## SETTINGS

require "Settings.pl";

$candidates_file = "$election_name/$candFN";	# list of candidates and links

$submitcgi = 'BallotParser.pl';			# name of cgi to submit ballot
						# to

use CGI;
require 'ballot_io.pl';

###############################################################################
## - CODE - (maybe move this to a common file?)

my $cgi = new CGI;			# for great html headers
print $cgi->header(-type => 'text/html');

$numcand = 0;				# number of candidates

# - SUB printSelection : prints html code for a combobox of N choices -

sub printSelection {
	# $_[0] = number of entries
	# $_[1] = value name (for select tag)
	
	my $numentries = shift;
	my $valname = shift;
	
	# ordinal suffixes: 0     1     2     3
	my @ordinal =     ( 'th', 'st', 'nd', 'rd');
	
	# first the html tag fun
	print '<select name="', $valname, "\">\n";
	# no preference / selected
	print "<option selected>No preference</option>\n";
	
	for (my $i = 1; $i <= $numentries; $i++) {
		#HTML
		print "\t<option>";
		
		# first print the number - this is easy
		print $i;
		
		#then the suffixes
		
		#11-20 are special, they all end with "th" (e.g eleventh)
		if ( ($i > 10) && ($i < 20) ) {
			print 'th';
		} else {
			$lastint = $i % 10;
			if ($lastint > 3) {	print 'th';	}
			else 		  {	print $ordinal[$lastint]; }
		}
		#closing HTML for each choice
		print "</option>\n";
	}
	#closing HTML for the select tag
	print "</select>\n";
}

###############################################################################
# - MAIN -

#open the files
open (HEADER, $init_html_file) or die "Cannot open header: $!";
open (FOOTER, $end_html_file) or die "Cannot open footer: $!";

#get candidates
$numcand = ballot_io::GetCandidates($candidates_file, \@candidates, 
	\@candidate_links);

# GUI IDEA:
#        +-------+---------------+------------+
#        |RANK   | CHOICE        | ACCEPTABLE |
#        +-------+---------------+------------+
#        | [pd]  | Mr. X         |    x       |
#        | [pd]  | Mr. Y         |    x       |
#        | [pd]  | Mr. Z         |    x       |
#        | [pd]  | Mr. W         |    x       |
#        +-------+---------------+------------+
#        | Select rank, then <Vote>           |
#        +------------------------------------+
#
#possibly a choice to put radio buttons instead of combolist.

#TODO: randomize candidate entries to normalize noise occurring from
#      ones who always ranks the top candidate first
#	DONE

# randomize candidate entries to normalize noise occurring from ones who
# always ranks the top (or bottom, or whatnot) candidate first

# this we do by first creating an array containing 0..numcand-1, and then
# shuffling it.

@old = 0 .. $numcand-1;
@shuffled = ();

for (@old) {
	my $r = rand @shuffled+1;
	push (@shuffled, $shuffled[$r]);
	$shuffled[$r] = $_;
}

# now print the header

while (<HEADER>) { print $_; }
close (HEADER);

#print form init

print '<form method="post" action="',$submitcgi,'">';
print '<table border=2>';

# explanation

print "<tr>\n";
print "\t<td><font size=\"+2\">Rank</font></td>\n";
print "\t<td><font size=\"+2\">Candidate</font></td>\n";
print "\t<td><font size=\"+2\">Acceptable</font></td>\n";
print "</tr>\n";

# ranking form itself

for ($i = 0; $i < $numcand; $i++) {
	print "<tr><td>\n";
	
	# rank
	printSelection($numcand, $candidates[$shuffled[$i]]);
	print "</td><td>\n";
	
	#candidate name/link
	print '<a href="', $candidate_links[$shuffled[$i]],'">';
	print $candidates[$shuffled[$i]], "</a>\n";

	#Acceptability (for NOTR calculation)
	print "</td><td>\n";
	print '<input type="checkbox" checked name="Accept',$candidates[$shuffled[$i]];
	print "\">\n";
	
	print "</td></tr>\n\n";
}

# "select rank then vote" message

print "<tr>\n";
print "\t<th colspan=3>\n";
print "\t\tRate the choices, then ";
print '<input type="submit" value="Vote"> or ';
print "<input type=\"reset\" value=\"reset the form\">\n";
print "\t</th>\n</tr>\n";

print "</table></form>\n";

#print footer, then close file
while (<FOOTER>) { print $_; }
close (FOOTER);
