#!/usr/bin/perl

# Parses CGI input from Interface.
# TODO: Cookie / IP double protection. (can be thwarted by not accepting
# cookies as well as logging in using another DUP)

###############################################################################
## SETTINGS

$hasvoted_file = 'HasVoted.html';		# file to display those who
						# have already voted.
$candidates_file = 'Candidates';                # list of candidates and links
$condorcet_matrix_file = 'CondorcetMatrix';	# condorcet matrix file
$ipordinal_file = 'Voters';			# list of those who have voted
						# plus what they voted
						# (to harden ballot stuffing)
###############################################################################
## CODE

@condorcet = ([],[]);
@condorcetNP = ([],[]);

require "ballot_io.pl";		# we require ballot IO functions
require "condorcet.pl";		# and general condorcet functions
use CGI;			# as well as a way of communicating to the user
use MD5;			# "for great IP obfuscation"

$cgi = new CGI;

if ($cgi->remote_host() == "") {
	die "Not run as a CGI!\n";
}

$identity = unpack("H*",MD5->hash($cgi->remote_host()));
				# we should really salt this, but that would
				# pose DB problems.
$identity =~ s/([A-F])/\u\1/gi;	# uppercase


###############################################################################
# Check if voter has already voted
# if (IP matches || Cookie matches) { has already voted }
# if he has not already voted, create a cookie here and add the IP to our list.
# if he has already voted, make a note to remove his earlier contribution to
# the cc matrix.

# TODO: fix this up using election names and expire dates, so that
# voting on one election won't block someone from voting in another.

# first assume he has not already voted
$hasVoted = 0;

# if he has a cookie, get it. We'll check it in the loop below
$ID = $cgi->cookie('VoterID');

#Sanity checking. Exit if get suspicious input.
if ($ID ne "") {
	if (length($ID) != 32) { exit; }	# MD5 is 128 bits
	if ($ID =~ tr/[0-9A-F]//c) { exit; }	# we don't want dangerous chars
}

# check his IP and ID against those who have already voted.
open (IVFILE, $ipordinal_file) or die "Cannot open ordinal file: $!";

if ($ID ne "") {
	while (<IVFILE>) {
		if (/($identity|$ID) : /io) {
			$hasVoted = 1;
			last;
		}
	}
} else {
	while (<IVFILE>) {
		if (/$identity : /io) {
			$hasVoted = 1;
			last;
		}
	}
}

close(IVFILE);

# if he has voted, let it be known.
if ($hasVoted == 1) {

	print $cgi->header(-type => 'text/html');

	open(HVFILE, $hasvoted_file) or die "Cannot open HasVoted file: $!";

	while (<HVFILE>) { print $_; }
	return;
}

# otherwise, set the has voted cookie.

$cookie = $cgi->cookie(-name => 'VoterID', -value => $identity,
	-expires => 'Sun, 30-Jun-2002 00:40:33 GMT');

print $cgi->header(-type => 'text/html', -cookie => $cookie);

###############################################################################
# get candidates - see Interface.pl for comments

open (CANDFILE, $candidates_file) or die "Cannot open candidate file: $!";

while (<CANDFILE>) {
	if ( !( (/#.*/) || (/^ *\n/) ) ) {
		s/\n//g;
		push (@candidates, $_);
		$link = <CANDFILE>;
		$link =~ s/\n//g;
		push (@candidate_links, $link);
		$numcand++;
	}
}

close(CANDFILE);

###############################################################################
# Calculate ranking

### Flat database:
# %candscore->{candidate} : rank of candidate - 1 is best
# %candnum->{candidate}   : candidate to number mapping (for matrix etc)
# $condorcet[for][against]: number of votes where "for" is ranked higher than
#			    "against"

$counter = 0;

# get the ranking and acceptability
foreach $current(@candidates) {
	# get the entry
	$score = $cgi->param($current);
	$_ = $score;

	# is the current candidate ranked / ranked sensibly?
	if ( (/(.*)(st|nd|rd|th)/) && ($1 > 0 && $1 <= $numcand)) {
		# yes, it is
		%candscore->{$current} = $1;
	} else {
		# no, it is not; assume No Preference (which is below every
		# ranked preference)
		%candscore->{$current} = $numcand+1;
	}
	
	# is he acceptable?
	if ($cgi->param("Accept$current") eq "on") {
		%candaccept->{$current} = 1;		# yes, he is
	} else {%candaccept->{$current} = 0; }		# no, he isn't
	
	# assign a number to this candidate
	%candnum->{$current} = $counter;
	$counter++;
	
	print $current, " is ranked as number ", %candscore->{$current};
	print "<br>\n";
}

#sort by value, so we can dump preference ranking to the vote list file, and
#later fill in the condorcet matrix.

@SortedCondorcet = sort { $candscore{$a} <=> $candscore{$b} } keys %candscore;

##########
#Dump preference ranking to ordinal file.

open (IVFILE, ">$ipordinal_file") or die "Cannot open ordinal file: $!";

$preference = $identity . ' : ';
for ($i = 0; $i < $numcand; $i++) {
	$preference .= $SortedCondorcet[$i];
	
	if ($i < ($numcand-1)) {
	
		# if the next candidate is less preferred...
		if ($candscore{$SortedCondorcet[$i+1]} > 
		    $candscore{$SortedCondorcet[$i]} ) {
		    	# show that
		    	$preference .= " > ";
		} else {
			# otherwise, show that he is equivalently reated.
			$preference .= " = ";
		}
	}
}
print IVFILE "$preference\n";

close(IVFILE);

#get condorcet matrix here

ballot_io::GetCondorcetMatrix(\@condorcet, \@condorcetNP, \@acceptability, 
	$condorcet_matrix_file, $numcand);

#create our local (this voter only) condorcet matrix that we later add to the 
#global (all prior voters) condorcet matrix.

#(N/2)(N+1) + N -> O(n^2)

print "<pre>";

# local acceptability matrix
# TODO: move the entire cgi thing down here unless too kludgy, move both
# functions to condorcet.pl

foreach $current(@candidates) {
	if (%candaccept->{$current} == 1) {
		$acceptability[%candnum->{$current}]++;
	}
}

# local condorcet

for ($y = 0; $y < $numcand-1; $y++) {
	$first = $SortedCondorcet[$y];		# first comparison candidate
	
	# candidate numbers for the condorcet array
	$ycand = $candnum{$first};

	# if we're at the lowest ranking candidate, it loses to everyone,
	# so we won't have to make any more comparisons, and we can just as
	# well get out of the loop.
	# NEW: commented out because ties have to be calculated in NP anyhow.
	#last if ($candscore{$first} == $numcand+1);  
	
	# Otherwise, since we're in sorted order, we only need to set victories
	# against lower ranked opponents.
	for ($x = $y+1; $x < $numcand; $x++) {
		$second = $SortedCondorcet[$x]; # second comparison candidate

		# candidate numbers for the condorcet array
		$xcand = $candnum{$second};

		# Relative rank: winner's rank - loser's rank
		# since we've already sorted the array, we know that the
		# winner will be the one whose counter ($x or $y) value is
		# least, and by the nature of the loop, $ycand's rank will
		# always be <= 0 when $xcand's is subtracted.
		
		$rank = $candscore{$first}-$candscore{$second};

		# three options: current candidate is better than the one we're
		# comparing (this is most likely), they're tied, or the
		# current candidate is worse than the one we're comparing it
		# to (in which case there's an error in the sorting algorithm).

		if ($rank < 0) {
			# y candidate better than x candidate
			$condorcet[$ycand][$xcand]++;
		} else {
			if ($rank > 0) {
				# x candidate better than y candidate
				print "ERROR<br>\n";
				$condorcet[$xcand][$ycand]++;
			} else {
				# tie
				$condorcetNP[$xcand][$ycand]++;
				$condorcetNP[$ycand][$xcand]++;
			}
		}
	}
}

###############################################################################
#Dump the modified matrices.

$output = "";

ballot_io::DumpCondorcetMatrix(\@condorcet, \@condorcetNP, \@acceptability,
		$condorcet_matrix_file, $numcand);
