#!/usr/bin/perl

# Output ballot results.

# (preliminary QND , commented later )

require "Settings.pl";

$candidates_file = "$election_name/$candFN";
$condorcet_matrix_file = "$election_name/$condorcetFN";

##############################################################################
## CODE

@condorcet = ([],[]);
@condorcetNP = ([],[]);

require "ballot_io.pl";
require "condorcet.pl";
require "electionSchulze.pl";

use CGI;
$cgi = new CGI;
print $cgi->header(-type => 'text/html');

# Get the candidates

$numcand = ballot_io::GetCandidates($candidates_file, \@candidates, 
		\@candidate_links);

# .. and condorcet matrix

$voters = ballot_io::GetVotingData(\@condorcet, \@condorcetNP, 
	\@acceptability, $condorcet_matrix_file, $numcand);

electionSchulze::ElectionInterface(\@condorcet, \@candidates, $numcand, 
	\%CandidateRanking, \%CandidateScore, $voters);

###############################################################################
# Okay, we have the election results. Now output it them in a formatted way.

# First, the header.
open(HEADER, $results_header) or die "Cannot open results header: $!\n";
while (<HEADER>) { print $_; }

# Then prepare to output the results sorted.
# We also have to merge tie scores here.

# 	Get sorted order

@SortedKeys = sort { $CandidateRanking{$a} <=> $CandidateRanking{$b} } keys %CandidateRanking;
$unique_entries =  grep { not $found{$_}++ } values(%CandidateRanking);

#	Merge ties -- for some strange reason, scores may differ for ties, 
#	which is counterintuitive. The experimental hacker may try to disable
#	this part and rank on scores alone. I do not know if that would weaken
#	Schulze significantly though.

for ($i = 0; $i < $numcand; $i++) {
	if ($CandidateRanking{$SortedKeys[$i]} == 
		$CandidateRanking{$SortedKeys[$i+1]}) {
		
		# We have a tie. Find how many ties there are, and sum up
		# the score so we can get an average later.

		$k = $i+1;
		$scoresum = $CandidateRanking{$SortedKeys[$i]};

		until ($CandidateRanking{$SortedKeys[$i]} !=
			$CandidateRanking{$SortedKeys[$k]}) {
			
			$scoresum += $CandidateScore{$SortedKeys[$k]}; # sum
			$k++;					       # inc
		}
		
		$scoresum = $scoresum / $k;	# get average

		# now change the scores
		for ($counter = $i; $counter < $k; $counter++) {
			$CandidateScore{$SortedKeys[$counter]} = $scoresum;
		}

		$i = $k;
	}
}

# --
# Output rank, and possibly score

#	Init table
print "<TABLE cellspacing=1 cellpadding=3 border=3>\n";
print "\t<tr>\n";
print "\t\t" . '<th rowspan=2 colspan=2 bgcolor="#c0c0ff">'."\n";
print "\t\t\tSchulze Rank: </th>";
print "\n";

#	1st, 2nd etc.
#	Code taken from Interface.

for ($i = 1; $i <= $unique_entries; $i++) {
	#  number itself
	print "\t\t" . '<td bgcolor="#c0ffc0"> ' . $i;
	#  ordinal
	$mod = $i % 10;
	if ( ( ($i < 10) || ($i > 19) ) && ($mod < 4) ) {
		if ( $mod == 0) { print "th"; }
		if ( $mod == 1) { print "st"; }
		if ( $mod == 2) { print "nd"; }
		if ( $mod == 3) { print "rd"; }
	} else {
		print "th";
	}
	print " </td>\n";
}

print "\t</tr>\n\t<tr>";

#	Candidate names
$oldrank = -900;	# nobody should get a negative rank, so we're safe

for ($i = 0; $i < $numcand; $i++) {
	# If this is not the second or Nth of a tie, then establish a new 
	# column
	if ($CandidateRanking{$SortedKeys[$i]} != $oldrank) {
		if ($i != 0) { print "</td>"; }
		print "\n\t\t".'<td bgcolor="#ffffff">';
		$oldrank = $CandidateRanking{$SortedKeys[$i]};
	} else {
		print "<br> ";
	}

	# print the candidate name
	print $SortedKeys[$i];
}
print "</td>\n\t</tr>\n";

#	print scores if enabled.

if ($usepercentages != 0) {
	
	$oldscore = -900;

	#	init

	print "\t\t" . '<th colspan=2 bgcolor="#c0c0ff">' . "\n";
	print "\t\t\t Score: </th>\n";

	for ($i = 0; $i < $numcand; $i++) {
		if ($CandidateScore{$SortedKeys[$i]} != $oldscore) {
			if ($i > 0) { print "</td>"; }
			print "\n\t\t" . '<td bgcolor="#ffffff">';
			printf( "%.1f %", $CandidateScore{$SortedKeys[$i]}, $oldscore);
			$oldscore = $CandidateScore{$SortedKeys[$i]};
		}
	}

	print "</td>\n";
	print "\t</tr>\n";
}

# close table

print "</table>\n";

# print footer.

open(HEADER, $results_footer) or die "Cannot open results footer: $!\n";
while (<HEADER>) { print $_; }

# and we're done.
