#!/usr/bin/perl

# Ballot I/O functions

require "condorcet.pl";		# for dumping the matrices

{

package ballot_io;

sub DumpCondorcetRow {
	# dumps condorcet row from an array to the relevant condorcet array
	# $_[0] = number of candidates
	# $_[1] = current y position
	# $_[2] = reference to output array
	# $_[3] = reference to input

	for(my $i = 0; $i < $_[0]; $i++) {
		${$_[2]}[$i][$_[1]] = ${$_[3]}[$i];#$dcrInput[$i];
	}
}

sub GetCandidates {
	my $candidates_file = shift;
	my $candarray = shift;		# reference to array to store candidate
					# names in
	my $candlinkarray = shift;	# same, but with candidate links

	my $link;
	my $numcand = 0;

	open (CANDFILE, $candidates_file) or die "Cannot open candidate file: $!";

	while (<CANDFILE>) {
		if ( !( (/#.*/) || (/^ *\n/) ) ) {
			s/\n//g;
			push(@{$candarray}, $_);
			$link = <CANDFILE>;
			$link =~ s/\n//g;
			push(@{$candlinkarray}, $link),
			$numcand++;
		}
	}

	close (CANDFILE);

	return($numcand);
}


sub GetCondorcetMatrix {
# GetCondorcetMatrix: Gets condorcet matrices (NPref and "real matrix") as well
# as acceptability list, then dumps them into the appropriate arrays.
# Only simple error checking is done, since the users won't have direct
# control of the files anyway.

# Only the real matrix would be required to perform an election, but
# the NP matrix is used for additional information, and the acceptability list
# for extended NOTA (NOTR).

	#$_[0] = reference to condorcet matrix
	#$_[1] = reference to condorcet NP matrix
	#$_[2] = reference to acceptability matrix
	#$_[3] = condorcet matrix file name
	#$_[4] = number of candidates

	my $counter;
	my @input;

	my $matrix = shift;
	my $NPMatrix = shift;
	my $acceptability = shift;
	my $condorcet_file = shift;
	my $numcand = shift;

	open(CMFILE, $condorcet_file) or 
		die "Cannot open condorcet matrix file: $!";

	while (<CMFILE>) {
		# is it the condorcet matrix?
		if ($_ eq "CONDMAT\n") {
			#Yes it is, parse the rest
			for ($counter = 0; $counter < $numcand; $counter++) {
				$numberline = <CMFILE>;		# get a line
				$numberline =~ s/\n//g;		# erase newline

				# dump to condorcet array
				@input = split(/ /, $numberline);
				DumpCondorcetRow($numcand, $counter, $matrix, 
					\@input);
			}
		}

		# is it the NP matrix?
		if ($_ eq "CONDNPMAT\n") {
			#Yes it is, parse the rest (see CONDMAT)
			for ($counter = 0; $counter < $numcand; $counter++) {
				$numberline = <CMFILE>;
				$numberline =~ s/\n//g;
				
				@input = split(/ /, $numberline);
				DumpCondorcetRow($numcand, $counter,
					$NPMatrix, \@input);
			}
		}

		# is it the acceptability list?
		if ($_ eq "ACCEPT\n") {
			$numberline = <CMFILE>;
			$numberline =~s/\n//g;
			@{$acceptability} = split(/ /, $numberline);
		}
	}

	close(CMFILE);

}

sub DumpCondorcetMatrix {
	#Does the inverse of what GetCondorcetMatrix does.
	#Overwrites the condorcet matrix file.

	#$_[0] = reference to condorcet matrix
        #$_[1] = reference to condorcet NP matrix
        #$_[2] = reference to acceptability matrix
        #$_[3] = condorcet matrix file name
        #$_[4] = number of candidates

	my $linear;	# this is the temporary variable we print for cond.
			# matrices

	# First, open the file.

	$filename = $_[3];

	open (CMFILE, ">$filename") or die "Cannot open condorcet matrix file: $!";

	#Then start printing...

	#condorcet matrix
	print CMFILE "CONDMAT\n";      # condorcet matrix ID
	print CMFILE condorcet::PrintCondorcetMatrix($_[0], $_[4]);

	#condorcet NP matrix
	print CMFILE "\nCONDNPMAT\n";  # condorcet NP matrix ID
	print CMFILE condorcet::PrintCondorcetMatrix($_[1], $_[4]);

	#acceptability array
	print CMFILE "\nACCEPT\n";
	foreach $i(@{$_[2]}) { print CMFILE "$i "; }
	print CMFILE "\n";

	close(CMFILE);
}
	
;1
}
