#TODO: optimally defeated, experimental ranking, etc

#Schulze election calculation

# A beatpath from A to N is a sequence A > ... > N, where ... is any number of
# candidates.

# For a Schulze election: If more prefer A indirectly to N than N to A, then
# N cannot place in front of N (note "indirectly" - with only "directly" we
# get Plain condorcet, which is vulnerable to ties).
# Thus we find the path A > ... > N and N > ... A. The strength of a beatpath
# is how many prefers a candidate to another in the beatpath, so that this
# preference is the lowest possible (since someone who prefers A to N has to
# prefer all of A to B, B to C, C to .., and ... to N)
# If the strength of A > ... > N is stronger than N > ... > A, then N is
# defeated.
# The candidate with no defeats wins. For ranked ordering, rank by defeats.

# The experimental score based scheme sets a score based inversely on the sum
# of the strength of the opposing beatpath. This has not been proven to be
# consistent, so use with care.


package electionSchulze;

{

# All points shortest path function. Used to find the strength of the shortest
# path of the form X > Y > ... > Z for all candidates. O(n^3), but functions 
# with better bounds exist, and could possibly replace this function. 
# (Floyd's Algorithm with optimizing step)

sub APSP {
	#$_[0] = reference to adjacency matrix 
	#		(Condorcet matrix for Schulze elections)
	#$_[1] = N for an NxN matrix
	#Output is $_[0] = APSP matrix.

	my $matrix = shift;
	my $N = shift;
	
	for (my $k = 0; $k < $N; $k++) {
		for (my $i = 0; $i < $N; $i++) {
			next if ($k == $i);			# optimize
			
			for (my $j = 0; $j < $N; $j++) {
				next if ($i == $j);		# optimize

				if ($$matrix[$i][$j] > $$matrix[$i][$k] +
					$$matrix[$k][$j]) {

					$$matrix[$i][$j] = $$matrix[$i][$k] + 
						$$matrix[$k][$j];
				}
			}
		}
	}
}

#-------------------

sub getDefeats {
	# get the number of defeats of each candidate

	# INPUT: $_[0] reference to APSP matrix
	#	 $_[1] number of candidates
	#        $_[2] reference to placeholder output matrix for number of
	#	       defeats
	#	 $_[3] reference to placeholder output matrix for strength of
	#	       defeats
	
	# OUTPUT: sets values of $_[2] and $_[3]

	$matrix = shift;		# APSP matrix		(ref)
	$candidates = shift;		# number of candidates
	$defeats = shift;		# defeat output matrix	(ref)
	$defeatstr = shift;		# defeat strength output matrix (ref)

	for (my $y = 0; $y < $candidates; $y++) {
		for (my $x = 0; $x < $candidates; $x++) {

			# if the first (y) candidate is preferred, either
			# directly or indirectly to the second (x), then
			# add the strength of the path y > ... > x to x's
			# defeat strength ($_[3]), and increment x's number
			# of defeats.

			next if ($x == $y) ;

			if ($$matrix[$y][$x] > $$matrix[$x][$y]) {
				$$defeats[$x]++;
				$$defeatstr[$x] += $$defeatsr[$y][$x];
			}
		}
	}
}

sub ElectionInterface {
	#Election Interface

	#$_[0] is the condorcet matrix
	#$_[1] is the list of candidates, first one is the one that comes
	#	first in the condorcet matrix, second the one that comes second
	#	and so on.
	#$_[2] is the number of candidates
	#$_[3] is a reference to a hash that when finished will contain
	#	all candidates, with their values set to their ranking,
	#	where lower is better.
	#$_[4] is a reference to a hash like $_[2], only it'll contain
	#	percentage ratings instead of simple 1..N scores
	#	(not implemented)

	#This implementation alters 0 and 3.

	APSP($_[0], $_[2]);	# get beatpaths

	my @defeats;
	my @defscore;		# anonymous array

	# clear scores

	for ($i = 0; $i < $_[2]; $i++) {
		$defeats[$i] = 0;
		$defscore[$i] = 0;
	}

	getDefeats($_[0], $_[2], \@defeats, \@defscore); # get defeats

	# Warning: yucky code follows

	my $currentCandidate;
	my $candidate_number = 0;

	my $rel_rank;

	# set the ranking array to defeats. We'll change it to the inverse
	# afterwards.
	foreach $currentCandidate(@{$_[1]}) {

		# a relative rank is one for which a higher ranked candidate
		# is assigned to a lower number and ties have the same
		# numbers, but not all numbers are used (if there are ties).

		# thus, use >, NOT (is number one, is number two, etc)
		
		$rel_rank = $defeats[$candidate_number];
	
		%{$_[3]}->{$currentCandidate} = $rel_rank;
		$candidate_number++;
	}

}

}

1;
