#TODO: optimally defeated, experimental ranking, etc

#Schulze election calculation

# A beatpath from A to N is a sequence A > ... > N, where ... is any number of
# candidates.

# For a Schulze election: If more prefer A indirectly to N than N to A, then
# N cannot place in front of N (note "indirectly" - with only "directly" we
# get Plain condorcet, which is vulnerable to ties).
# Thus we find the path A > ... > N and N > ... A. The strength of a beatpath
# is how many prefers a candidate to another in the beatpath, so that this
# preference is the lowest possible (since someone who prefers A to N has to
# prefer all of A to B, B to C, C to .., and ... to N)
# If the strength of A > ... > N is stronger than N > ... > A, then N is
# defeated.
# The candidate with no defeats wins. For ranked ordering, rank by defeats.

# The experimental score based scheme sets a score based inversely on the sum
# of the strength of the opposing beatpath. This has not been proven to be
# consistent, so use with care.


package electionSchulze;

{

# All points shortest path function. Used to find the strength of the shortest
# path of the form X > Y > ... > Z for all candidates. O(n^3), but functions 
# with better bounds exist, and could possibly replace this function. 
# (Floyd's Algorithm with optimizing step)

sub APSP {
	#$_[0] = reference to adjacency matrix 
	#		(Condorcet matrix for Schulze elections)
	#$_[1] = N for an NxN matrix
	#Output is $_[0] = APSP matrix.

	#my $matrix = shift;
	#my $N = shift;

	# Now uses the correct algorithm.
	# Alter to use margins if you want.

	# TODO: Make this the Debian version.

	my $condorcetM = shift;
	my $length = shift;

	my @p_margins = ([],[]);
	my @p_wv = ([],[]);

	my $i;
	my $j;
	my $k;

	for ($i = 0; $i < $length; $i++) {
		for ($j = 0; $j < $length; $j++) {
			next if ($i == $j);

			$$p_margins[$i][$j] = $$condorcetM[$i][$j] - 
				$$condorcetM[$j][$i];
			if ($$condorcetM[$i][$j] > $$condorcetM[$j][$i]) {
				$$p_wv[$i][$j] = $$condorcetM[$i][$j];
			} else {
				$$p_wv[$i][$j] = 0;
			}
		}
	}

	my $t;
	my $s;

	for ($i = 0; $i < $length; $i++) {
		for ($j = 0; $j < $length; $j++) {
			next if ($i == $j);
			for ($k = 0; $k < $length; $k++) {
				next if ($i == $k);
				next if ($j == $k);

				$s = $$p_wv[$j][$i];
				$t = $$p_margins[$j][$i];

				if ( ($$p_wv[$i][$k] < $s) || 
				     ($$p_margins[$i][$k] < $t) && 
				     ($$p_wv[$i][$k] == $s) ) {

				     $s = $$p_wv[$i][$k];
				     $t = $$p_margins[$i][$k];
				}

				if ( ($$p_wv[$j][$k] < $s) ||
				     ($$p_margins[$j][$k] < $t) &&
				     ($$p_wv[$j][$k] == $s) ) {

				     $$p_wv[$j][$k] = $s;
				     $$p_margins[$j][$k] = $t;
				}
			}
		}
	}

	# Write beatpath matrix over our input.

	for ($i = 0; $i < $length; $i++) {
		for ($j = 0; $j < $length; $j++) {
			$$condorcetM[$i][$j] = $$p_wv[$i][$j];
		}
	}
	
	
	#for (my $k = 0; $k < $N; $k++) {
	#	for (my $i = 0; $i < $N; $i++) {
	#		next if ($k == $i);			# optimize
	#		
	#		for (my $j = 0; $j < $N; $j++) {
	#			next if ($i == $j);		# optimize

	#			if ($$matrix[$i][$j] > $$matrix[$i][$k] +
	#				$$matrix[$k][$j]) {

	#				$$matrix[$i][$j] = $$matrix[$i][$k] + 
	#					$$matrix[$k][$j];
	#			}
	#		}
	#	}
	#}
}

#-------------------

sub getDefeats {
	# get the number of defeats of each candidate

	# INPUT: $_[0] reference to APSP matrix
	#	 $_[1] number of candidates
	#        $_[2] reference to placeholder output matrix for number of
	#	       defeats
	#	 $_[3] reference to placeholder output matrix for strength of
	#	       defeats
	
	# OUTPUT: sets values of $_[2] and $_[3]

	my $matrix = shift;		# APSP matrix		(ref)
	my $candidates = shift;		# number of candidates
	my $defeats = shift;		# defeat output matrix	(ref)
	my $defeatstr = shift;		# defeat strength output matrix (ref)

	for (my $y = 0; $y < $candidates; $y++) {
		for (my $x = 0; $x < $candidates; $x++) {

			# if the first (y) candidate is preferred, either
			# directly or indirectly to the second (x), then
			# add the strength of the path y > ... > x to x's
			# defeat strength ($_[3]), and increment x's number
			# of defeats.

			next if ($x == $y) ;

			if ($$matrix[$y][$x] > $$matrix[$x][$y]) {
				$$defeats[$x]++;
				$$defeatstr[$x] += $$matrix[$y][$x];
			}
		}
	}
}

sub ElectionInterface {
	#Election Interface

	#$_[0] is the condorcet matrix
	#$_[1] is the list of candidates, first one is the one that comes
	#	first in the condorcet matrix, second the one that comes second
	#	and so on.
	#$_[2] is the number of candidates
	#$_[3] is the reference to a hash that when finished will contain
	#	the relative ranking of every candidate, ordered in the way
	#	that the candidates are given in the matrix.
	#$_[4] same as 3, only gives the percentage rating (EXPERIMENTAL)
	#$_[5] is the number of voters

	#This implementation alters 0, 3 and 4.

	my $matrix = shift;
	my $candidates = shift;
	my $numcand = shift;
	my $rank_out = shift;
	my $score_out = shift;
	my $voters = shift;

	APSP($matrix, $numcand);	# get beatpaths

	my @defeats;		# number of defeats
	my @defscore;		# defeat "strength"
	my @score;

	# clear scores

	for ($i = 0; $i < $numcand; $i++) {
		$defeats[$i] = 0;
		$defscore[$i] = 0;
	}

	getDefeats($matrix, $numcand, \@defeats, \@defscore); # get defeats

	# Warning: yucky code follows

	my $currentCandidate;
	my $candidate_number = 0;

	my $rel_rank;
	my $rel_score;

	# rating

	# see comments for GetZeroPercent for why this is required.
	my $zerocand = GetZeroPercent($voters, $numcand, $matrix, \@defscore);

	GetRating(\@defeats, \@defscore, $numcand, \@score, $zerocand);

	# set the ranking array to defeats. We'll change it to the inverse
	# afterwards.
	foreach $currentCandidate(@{$candidates}) {

		# a relative rank is one for which a higher ranked candidate
		# is assigned to a lower number and ties have the same
		# numbers, but not all numbers are used (if there are ties).

		# thus, use >, NOT (is number one, is number two, etc)
		
		my $rel_rank = $defeats[$candidate_number];
		my $rel_score = $score[$candidate_number];
	
		%{$rank_out}->{$currentCandidate} = $rel_rank;
		%{$score_out}->{$currentCandidate} = $rel_score;
		$candidate_number++;
	}

}

#------------------------------------------------------------------------------
# EXPERIMENTAL: Ratings (percentages)

sub GetZeroPercent {
	# returns the defeat strength equivalent to 0% (no support; ranked last
	# by everyone).

	# If there is a candidate that is ranked in such a way, find him by
	# searching the condorcet matrix.

	# If not, the hypothetical strength is (voters * (candidates+1)).

	# --
	# $_[0] = number of voters
	# $_[1] = number of candidates
	# $_[2] = reference to condorcet matrix
	# $_[3] = reference to defeat strength array

	my $numvoters = shift;
	my $numcand = shift;
	my $matrix = shift;
	my $defeatstrength = shift;

	my $record = 0;

	# (yes, you could get this down from 2N to N, but not really
	#  worth it)

	# first check the matrix for a candidate ranked last by everyone
	# let's find the candidate with the highest defeat strength first
	# (since the zero percent candidate, if any, must be that one)
	# If there's a tie, either one will qualify for the 0% position

	my $cand;
	for ($cand = 0; $cand < $numcand; $cand++) {
		if($$defeatstrength[$cand] > $$defeatstrength[$record]) {
			$record = $cand;
		}
	}

	# now check the condorcet matrix if he's been voted > last by anyone

	$victory = 0;	# assume not.

	for ($cand = 0; ($cand < $numcand) && ($victory == 0); $cand++) {
		if ($$matrix[$record][$cand] > 0) { $victory = 1; }
	}

	# return the correct value
	if ($victory == 1) {
		# hypothetical candidate: voters * (candidates+1)
		return ($numvoters * ($numcand + 1) );
	}
	# 0% candidate's value
	return ($$defeatstrength[$record]);

}

sub GetRating {
	# does what it says. Note that this has not been tested completely.
	# First we normalize to percentages where the victor is equal to 100%
	# and the 0% candidate to 0% (see previous function).
	# Then by assuming that the max score of each is just below that which
	# would get them to the next place, we derive that the normalized 
	# scores are partitioned in a way like [0...1/N, 1/N...2/N, ... ] for
	# candidates 0 (loser) to N (victor).
	# Ties are in the same space, so each candidate is partitioned within
	# [(K-1)/N...K/N] where K is the number of victories (N-defeats).
	# When we have removed that effect, rescale all percentages so that
	# the sum is 100%, then we're finished.

	# $_[0] = array reference to number of defeats for each candidate
	# $_[1] = array reference to defeat strength for each candidate
	# $_[2] = number of candidates
	# $_[3] = reference to array where output is to be stored, in
	#	  condorcet order
	# $_[4] = zero percent candidate's defeat strength

	my $defeats = shift;
	my $defstrength = shift;
	my $numcand = shift;
	my $outputarray = shift;
	my $zpcstrength = shift;

	my $counter;
	my $current;
	my $sum = 0;	# for setting sum to 100% at the end
	my $victories;

	for ($counter = 0; $counter < $numcand; $counter++) {
		# Set normalized so that victor's strength (0) is 100% (1) and
		# loser's strength is 0% (0)
		
		$current = 0; #($zpcstrength-$$defstrength[$counter])/$zpcstrength;
		# move from [(K-1)/N ... K/N] to [0..1]
		# output = (K-1+input)/N

		$victories = $numcand-$$defeats[$counter];
		$current = ($victories-1+$current)/$numcand;
		
		$$outputarray[$counter] = $current;
		$sum = $sum + $current;
	}

	# fix the scores so that its sum is 100%, and change from 1/x
	# (1 is max) to percentages (100 is max)

	for ($counter = 0; $counter < $numcand; $counter++) {
		$$outputarray[$counter] = 100*($$outputarray[$counter]/$sum);
	}
		
}

#- Perl wrapper -
}
1;
